Public Class Counter2
  Private Shared FValue As Long

  Public Shared Sub Reset()
    FValue = -1
  End Sub

  Public Shared ReadOnly Property Value() As Long
    Get
      FValue += 1
      Return FValue
    End Get
  End Property

End Class

Public Class Counter

  Public Shared Function Value(Optional ByVal Reset As Boolean = False, _
    Optional ByVal Seed As Long = 0) As Long

    Static I As Long = Seed
    If (Reset) Then
      I = Seed
    Else
      I += 1
    End If

    Return I
  End Function

  Public Shared Function Str(Optional ByVal Reset As Boolean = False, _
    Optional ByVal Length As Long = 1) As String

    Static S As String = New System.String("A", Length)
    If (Reset) Then
      S = New System.String("A", Length)
    Else
      S = Roll(S, "A", "Z")
    End If

    Return S
  End Function

  Private Shared Function Chunk(ByVal Str As String) As String
    Return Right(Str, Str.Length() - 1)
  End Function

  Private Shared Function Roll(ByVal S As String, ByVal Low As Char, _
    ByVal High As Char) As String
    If (S.Length() = 0) Then
      S = Low
    ElseIf (S.Chars(0) < High) Then
      S = Chr(Asc(S) + 1) + Chunk(S)
    Else
      S = Low + Roll(Chunk(S), Low, High)
    End If

    Return S
  End Function

  Public Shared Function Digits(Optional ByVal Reset As Boolean = False, _
    Optional ByVal Length As Long = 1) As String

    Static D As String = New System.String("0", Length)
    If (Reset) Then
      D = New System.String("0", Length)
    Else
      D = Roll(D, "0", "9")
    End If

    Return D
  End Function


End Class

